/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.DieselGeneratorValueBox;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity {
    BlockState state;
    boolean weak;
    boolean slow;
    public boolean validFuel;
    private final TagKey<Fluid> tagSS = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_slow_strong"));
    private final TagKey<Fluid> tagFS;
    private final TagKey<Fluid> tagFW;
    private final TagKey<Fluid> tagSW = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_slow_weak"));
    private final TagKey<Fluid> tagPlantOil;
    private final TagKey<Fluid> tagFuel;
    private final TagKey<Fluid> tagEthanol;
    private final TagKey<Fluid> tagBiodiesel;
    private SmartFluidTankBehaviour tank;
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    int t = 0;
    float lastsp = 0.0f;

    public DieselGeneratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.tagFS = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_fast_strong"));
        this.tagFW = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_fast_weak"));
        this.tagPlantOil = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:plantoil"));
        this.tagFuel = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:fuel"));
        this.tagEthanol = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:ethanol"));
        this.tagBiodiesel = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:biodiesel"));
        this.state = state;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.state.m_61143_((Property)DieselGeneratorBlock.FACING) == Direction.DOWN) {
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.WEST) {
                return this.tank.getCapability().cast();
            }
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.EAST) {
                return this.tank.getCapability().cast();
            }
        } else if (this.state.m_61143_((Property)DieselGeneratorBlock.FACING) == Direction.UP) {
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.NORTH) {
                return this.tank.getCapability().cast();
            }
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.SOUTH) {
                return this.tank.getCapability().cast();
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.tank.write(compound, false);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.read(compound, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new DieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged() {
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        if (this.getGeneratedSpeed() == 0.0f) {
            return 0.0f;
        }
        if (this.weak) {
            return ((Double)ConfigRegistry.WEAK_STRESS.get()).floatValue() / Math.abs(this.getGeneratedSpeed());
        }
        return ((Double)ConfigRegistry.STRONG_STRESS.get()).floatValue() / Math.abs(this.getGeneratedSpeed());
    }

    public float getGeneratedSpeed() {
        if (this.validFuel) {
            if (this.slow) {
                return DieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * ((Double)ConfigRegistry.SLOW_SPEED.get()).floatValue()), (Direction)((Direction)this.m_58900_().m_61143_((Property)DieselGeneratorBlock.FACING)));
            }
            return DieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * ((Double)ConfigRegistry.FAST_SPEED.get()).floatValue()), (Direction)((Direction)this.m_58900_().m_61143_((Property)DieselGeneratorBlock.FACING)));
        }
        return 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        Lang.fluidName((FluidStack)this.tank.getPrimaryHandler().getFluid()).style(ChatFormatting.GRAY).space().add(Lang.number((double)this.tank.getPrimaryHandler().getFluid().getAmount()).style(ChatFormatting.DARK_GRAY)).add(Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip);
        return true;
    }

    public void tick() {
        super.tick();
        this.state = this.m_58900_();
        this.updateGeneratedRotation();
        if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagFS) || ((Boolean)ConfigRegistry.FUEL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagFuel) || ((Boolean)ConfigRegistry.BIODIESEL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagBiodiesel)) {
            this.validFuel = true;
            this.slow = false;
            this.weak = false;
        } else if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagFW) || ((Boolean)ConfigRegistry.ETHANOL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagEthanol)) {
            this.validFuel = true;
            this.slow = false;
            this.weak = true;
        } else if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagSS) || ((Boolean)ConfigRegistry.PLANTOIL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagPlantOil)) {
            this.validFuel = true;
            this.slow = true;
            this.weak = false;
        } else if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagSW)) {
            this.validFuel = true;
            this.slow = true;
            this.weak = true;
        } else {
            this.validFuel = false;
        }
        if (this.lastsp != this.getGeneratedSpeed()) {
            this.changeBlockstate((BlockState)this.state.m_61124_((Property)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(this.validFuel)));
            this.lastsp = this.getGeneratedSpeed();
        }
        if (this.t > 2) {
            if (this.validFuel) {
                this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (int)(this.tank.getPrimaryHandler().getFluid().getAmount() - 1)));
                this.t = 0;
                if (!((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.SILENCED)).booleanValue()) {
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_144098_, SoundSource.BLOCKS, 3.0f, 1.18f, false);
                    AllSoundEvents.STEAM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.05f, 0.8f, false);
                }
            }
        } else {
            ++this.t;
        }
    }

    private void changeBlockstate(BlockState state) {
        this.f_58857_.m_7731_(this.m_58899_(), state, 3);
    }
}

